/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.launcher;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Patcher {
    private static final byte[] BUFFER = new byte[1024];

    public static final int applyPatches(File file, boolean bl) throws IOException {
        File file2 = new File(".");
        int n = 1;
        while (true) {
            block12: {
                File file3;
                if ((file3 = new File(file, "patch-" + n + ".zip")).isFile()) {
                    if (bl) {
                        System.out.println("\n- Applying patch file [" + file3.getPath() + "]");
                    }
                    try {
                        try {
                            Patcher.process(file3, file2, bl);
                        }
                        catch (Exception exception) {
                            System.out.println("*** Error while applying patch [ " + file3.getPath() + "] : ");
                            exception.printStackTrace(System.out);
                            System.out.println("- Deleting patch file [" + file3.getPath() + "]\n");
                            if (!file3.delete()) {
                                file3.deleteOnExit();
                            }
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        System.out.println("- Deleting patch file [" + file3.getPath() + "]\n");
                        if (!file3.delete()) {
                            file3.deleteOnExit();
                        }
                        throw throwable;
                    }
                    System.out.println("- Deleting patch file [" + file3.getPath() + "]\n");
                    if (!file3.delete()) {
                        file3.deleteOnExit();
                    }
                } else {
                    return n - 1;
                }
            }
            ++n;
        }
    }

    private static final void process(File file, File file2, boolean bl) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                File file3 = new File(file2, string);
                if (zipEntry.isDirectory()) {
                    if (file3.isDirectory()) continue;
                    if (bl) {
                        System.out.println("   Creating Folder : " + string);
                    }
                    file3.mkdirs();
                    if (file3.isDirectory()) continue;
                    throw new IOException("Failed to create directory : " + Patcher.getPath(file3));
                }
                if (bl) {
                    System.out.println("   Extracting File : " + string);
                }
                file3.getParentFile().mkdirs();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                if (inputStream != null) {
                    Patcher.copyInputStream(inputStream, file3);
                    if (file3.isFile()) continue;
                    throw new IOException("Failed to create file : " + Patcher.getPath(file3));
                }
                throw new IOException("Failed to read zipped file : " + string);
            }
        }
        finally {
            zipFile.close();
        }
    }

    private static final void copyInputStream(InputStream inputStream, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            while ((n = inputStream.read(BUFFER)) >= 0) {
                ((OutputStream)bufferedOutputStream).write(BUFFER, 0, n);
            }
        }
        finally {
            inputStream.close();
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    private static final String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }
}

